/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.watermark;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;

public class Watermark {
    public static final int H_LEFT = 0;
    public static final int H_CENTER = 1;
    public static final int H_RIGHT = 2;
    public static final int V_TOP = 0;
    public static final int V_MIDDLE = 1;
    public static final int V_BOTTOM = 2;
    public static final boolean INVISIBLE = true;
    public static final boolean VISIBLE = true;
    private Image m_image;
    private int m_imgWidth;
    private int m_imgHeight;
    private int m_horiz;
    private int m_vert;
    private int m_indentx;
    private int m_indenty;
    private boolean m_visible;
    private URL m_url;
    private Rectangle m_rect;

    public Watermark(Image img, int horiz, int vert, int indentx, int indenty) {
        this(img, horiz, vert, indentx, indenty, null);
    }

    public Watermark(Image img, int horiz, int vert, int indentx, int indenty, String url) {
        this(img, horiz, vert, indentx, indenty, url, true);
    }

    public Watermark(Image img, int horiz, int vert, int indentx, int indenty, String url, boolean visible) {
        this.m_image = img;
        this.m_imgWidth = this.m_image.getWidth(null);
        this.m_imgHeight = this.m_image.getHeight(null);
        this.m_rect = new Rectangle(0, 0, 0, 0);
        this.m_horiz = horiz;
        this.m_vert = vert;
        this.m_indentx = indentx;
        this.m_indenty = indenty;
        this.m_visible = visible;
        if (url != null && !url.equals("")) {
            try {
                this.m_url = new URL(url);
            }
            catch (MalformedURLException mfe) {
                System.err.println("Unable to process watermark link URL - '" + url + "' - not clickable");
            }
        }
    }

    public void paint(Graphics g) {
        if (this.m_visible) {
            g.drawImage(this.m_image, this.m_rect.x, this.m_rect.y, null);
        }
    }

    public boolean hitsPoint(Point p) {
        return this.m_rect.contains(p);
    }

    public boolean isClickable() {
        return this.m_visible && this.m_url != null;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void recalculateLocation(Dimension d) {
        int x = 0;
        int y = 0;
        switch (this.m_horiz) {
            case 0: {
                x = this.m_indentx;
                break;
            }
            case 1: {
                x = (d.width - this.m_imgWidth) / 2;
                break;
            }
            case 2: {
                x = d.width - this.m_indentx - this.m_imgWidth;
                break;
            }
            default: {
                throw new RuntimeException("Illegal Horizontal Anchor position - " + this.m_horiz);
            }
        }
        switch (this.m_vert) {
            case 0: {
                y = this.m_indenty;
                break;
            }
            case 1: {
                y = (d.height - this.m_imgHeight) / 2;
                break;
            }
            case 2: {
                y = d.height - this.m_indenty - this.m_imgHeight;
                break;
            }
            default: {
                throw new RuntimeException("Illegal Vertical Anchor position - " + this.m_horiz);
            }
        }
        this.m_rect.setBounds(x, y, this.m_imgWidth, this.m_imgHeight);
    }
}

