/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola;

import java.awt.Point;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class ClickCatcher {
    public String m_singleClick;
    public String m_doubleClick;

    public void setSingleClick(String single) {
        if (single == null || single.length() == 0) {
            single = null;
        }
        this.m_singleClick = single;
    }

    public void setDoubleClick(String dbl) {
        if (dbl == null || dbl.length() == 0) {
            dbl = null;
        }
        this.m_doubleClick = dbl;
    }

    public void mouseClicked(URL base, Point p) {
        if (this.m_singleClick == null) {
            return;
        }
        this.fireRequestTo(base, this.m_singleClick, p);
    }

    public void mouseDoubleClicked(URL base, Point p) {
        if (this.m_doubleClick == null) {
            return;
        }
        this.fireRequestTo(base, this.m_doubleClick, p);
    }

    void fireRequestTo(URL base, String mainString, Point p) {
        String xr = this.replaceString(mainString, "$x", "" + p.x);
        String req = this.replaceString(xr, "$y", "" + p.y);
        try {
            URL target = new URL(base, req);
            System.err.println("Click request to: " + target);
            URLConnection uc = target.openConnection();
            String dummy = uc.getContentType();
        }
        catch (MalformedURLException e) {
            System.err.println("Failed to make URL for click request to " + req + ": " + e);
        }
        catch (IOException e) {
            System.err.println("Failed to make HTTP click request to " + req + ": " + e);
        }
    }

    String replaceString(String source, String match, String replaceWith) {
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = source.indexOf(match, startIdx)) >= 0) {
            result.append(source.substring(startIdx, idxOld));
            result.append(replaceWith);
            startIdx = idxOld + match.length();
        }
        result.append(source.substring(startIdx));
        return result.toString();
    }
}

