/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.watermark;

import com.charliemouse.cambozola.watermark.Watermark;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class WatermarkCollection {
    public static final String NO_URL = null;
    public static final int DEFAULT_INDENT = 5;
    private Vector m_watermarks = new Vector();

    public void populate(String wmstr, URL docBase) {
        Toolkit dt = Toolkit.getDefaultToolkit();
        MediaTracker mt = new MediaTracker(new Panel());
        int wmid = 0;
        if (wmstr.length() == 0) {
            return;
        }
        StringTokenizer wmst = new StringTokenizer(wmstr, "| ");
        try {
            do {
                String imgurl = wmst.nextToken();
                String corner = "BottomRight";
                if (wmst.hasMoreTokens()) {
                    corner = wmst.nextToken();
                }
                String clickTarget = null;
                if (wmst.hasMoreTokens()) {
                    clickTarget = wmst.nextToken();
                }
                corner = corner.toLowerCase();
                int horiz = 1;
                int vert = 1;
                if (corner.indexOf("top") != -1 || corner.indexOf("north") != -1) {
                    vert = 0;
                } else if (corner.indexOf("bottom") != -1 || corner.indexOf("south") != -1) {
                    vert = 2;
                }
                if (corner.indexOf("left") != -1 || corner.indexOf("west") != -1) {
                    horiz = 0;
                } else if (corner.indexOf("right") != -1 || corner.indexOf("east") != -1) {
                    horiz = 2;
                }
                try {
                    URL wmImgURL = new URL(docBase, imgurl);
                    Image img = dt.createImage((ImageProducer)wmImgURL.getContent());
                    mt.addImage(img, wmid);
                    try {
                        mt.waitForID(wmid);
                        int stat = mt.statusID(wmid, true);
                        if (stat != 8) {
                            System.err.println("Not all watermarks could be loaded - status=" + stat);
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    ++wmid;
                    this.m_watermarks.addElement(new Watermark(img, horiz, vert, 5, 5, clickTarget));
                }
                catch (MalformedURLException mfe) {
                    System.err.println("Unable to access watermark URL - '" + imgurl + "' : " + mfe);
                }
                catch (IOException ie) {
                    System.err.println("Unable to access image data for '" + imgurl + "' : " + ie);
                }
            } while (wmst.hasMoreTokens());
        }
        catch (NoSuchElementException nsee) {
            System.err.println("Invalid watermark string '" + wmstr + "'");
        }
    }

    public Watermark isOverClickableWatermark(Point p) {
        Watermark wm = this.getWatermarkAtPoint(p);
        if (wm != null && wm.isClickable()) {
            return wm;
        }
        return null;
    }

    public Watermark getWatermarkAtPoint(Point p) {
        Enumeration itr = this.m_watermarks.elements();
        while (itr.hasMoreElements()) {
            Watermark wm = (Watermark)itr.nextElement();
            if (!wm.hitsPoint(p) || !wm.isVisible()) continue;
            return wm;
        }
        return null;
    }

    public void recalculateLocations(Dimension d) {
        Enumeration itr = this.m_watermarks.elements();
        while (itr.hasMoreElements()) {
            Watermark wm = (Watermark)itr.nextElement();
            wm.recalculateLocation(d);
        }
    }

    public void paint(Graphics g) {
        Enumeration itr = this.m_watermarks.elements();
        while (itr.hasMoreElements()) {
            Watermark wm = (Watermark)itr.nextElement();
            wm.paint(g);
        }
    }
}

