/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.shared;

import com.charliemouse.cambozola.shared.Base64;
import com.charliemouse.cambozola.shared.ExceptionReporter;
import com.charliemouse.cambozola.shared.ImageChangeEvent;
import com.charliemouse.cambozola.shared.ImageChangeListener;
import com.charliemouse.cambozola.shared.StreamSplit;
import com.charliemouse.cambozola.shared.TaiStreamSplit;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CamStream
extends Thread {
    public static final int CONNECT_STYLE_SOCKET = 1;
    public static final int CONNECT_STYLE_HTTP = 2;
    private static final int IMG_FLUFF_FACTOR = 1;
    private ExceptionReporter m_reporter = null;
    private Vector m_listeners;
    private Object m_lock = new Object();
    private Image m_imain = null;
    private Toolkit m_tk = Toolkit.getDefaultToolkit();
    private URL m_stream;
    private String m_userpassEncoded;
    private URL m_docBase;
    private DataInputStream m_inputStream = null;
    private boolean m_isDefunct = false;
    private boolean m_collecting = false;
    private byte[] m_rawImage;
    private String m_imageType = "image/jpeg";
    private long m_startTime = 0L;
    private int m_imgidx = 0;
    private int m_retryCount = 1;
    private int m_retryDelay = 1000;
    private String m_appName = "";
    private boolean m_defaultStreamProcessor = true;
    private boolean m_debug = true;

    public CamStream(URL strm, String app, URL docBase, int retryCount, int retryDelay, ExceptionReporter reporter, boolean debug) {
        this.m_listeners = new Vector();
        this.m_stream = strm;
        String userPass = strm.getUserInfo();
        this.m_userpassEncoded = null;
        if (userPass != null && userPass.length() > 0) {
            this.m_userpassEncoded = Base64.encode(userPass.getBytes());
        }
        this.m_appName = app;
        this.m_reporter = reporter;
        this.m_isDefunct = false;
        this.m_docBase = docBase;
        this.m_retryCount = retryCount;
        this.m_retryDelay = retryDelay;
        this.m_debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getCurrent() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_imain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRawImage() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_rawImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_imgidx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_imageType;
        }
    }

    public URL getStreamURL() {
        return this.m_stream;
    }

    public double getFPS() {
        if (this.m_startTime == 0L) {
            return 0.0;
        }
        long currTime = System.currentTimeMillis();
        return 1000.0 * (double)(this.m_imgidx - 1) / (double)(currTime - this.m_startTime);
    }

    public void addImageChangeListener(ImageChangeListener cl) {
        this.m_listeners.addElement(cl);
    }

    public void removeImageChangeListener(ImageChangeListener cl) {
        this.m_listeners.removeElement(cl);
    }

    private void fireImageChange() {
        ImageChangeEvent ce = new ImageChangeEvent(this);
        Enumeration e = this.m_listeners.elements();
        while (e.hasMoreElements()) {
            ((ImageChangeListener)e.nextElement()).imageChanged(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamSplit ssplit = null;
        try {
            String connectionError = null;
            String ctype = null;
            Hashtable headers = null;
            int tryIndex = 0;
            int retryCount = this.m_retryCount;
            int retryDelay = this.m_retryDelay;
            do {
                ++tryIndex;
                if (this.m_debug) {
                    System.err.println("// Connection URL = " + this.m_stream);
                }
                URLConnection conn = this.m_stream.openConnection();
                if (this.m_docBase != null) {
                    conn.setRequestProperty("Referer", this.m_docBase.toString());
                }
                conn.setRequestProperty("User-Agent", this.m_appName);
                conn.setRequestProperty("Host", this.m_stream.getHost());
                if (this.m_userpassEncoded != null) {
                    conn.setRequestProperty("Authorization", "Basic " + this.m_userpassEncoded);
                }
                this.m_inputStream = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
                headers = StreamSplit.readHeaders(conn);
                ssplit = this.m_defaultStreamProcessor ? new StreamSplit(this.m_inputStream) : new TaiStreamSplit(this.m_inputStream);
                if (this.m_debug) {
                    System.err.println("// Request sent; Main Response headers:");
                    Enumeration enm = headers.keys();
                    while (enm.hasMoreElements()) {
                        String hkey = (String)enm.nextElement();
                        System.err.println("//   " + hkey + " = " + headers.get(hkey));
                    }
                }
                this.m_collecting = true;
                connectionError = null;
                ctype = (String)headers.get("content-type");
                if (ctype == null) {
                    connectionError = "No main content type";
                } else if (ctype.indexOf("text") != -1) {
                    String response = null;
                    while ((response = this.m_inputStream.readLine()) != null) {
                        System.out.println(response);
                    }
                    connectionError = "Failed to connect to server (denied?)";
                }
                if (connectionError == null) break;
                if (this.m_isDefunct) {
                    return;
                }
                if (this.m_debug) {
                    System.err.println("// Waiting for " + retryDelay + " ms");
                }
                this.m_reporter.reportFailure(connectionError);
                Thread.sleep(retryDelay);
            } while (tryIndex < retryCount);
            if (connectionError != null) {
                return;
            }
            int bidx = ctype.indexOf("boundary=");
            String boundary = "--";
            if (bidx != -1) {
                boundary = ctype.substring(bidx + 9);
                ctype = ctype.substring(0, bidx);
                if (boundary.startsWith("\"") && boundary.endsWith("\"")) {
                    boundary = boundary.substring(1, boundary.length() - 1);
                }
                if (!boundary.startsWith("--")) {
                    boundary = "--" + boundary;
                }
            }
            if (ctype.startsWith("multipart/x-mixed-replace")) {
                if (this.m_debug) {
                    System.err.println("// Reading up to boundary");
                }
                ssplit.skipToBoundary(boundary);
            }
            do {
                if (this.m_collecting) {
                    if (boundary != null) {
                        headers = ssplit.readHeaders();
                        if (this.m_debug) {
                            System.err.println("// Chunk Headers recieved:");
                            Enumeration enm = headers.keys();
                            while (enm.hasMoreElements()) {
                                String hkey = (String)enm.nextElement();
                                System.err.println("//   " + hkey + " = " + headers.get(hkey));
                            }
                        }
                        if (ssplit.isAtStreamEnd()) {
                            break;
                        }
                        ctype = (String)headers.get("content-type");
                        if (ctype == null) {
                            throw new Exception("No part content type");
                        }
                    }
                    if (ctype.startsWith("multipart/x-mixed-replace")) {
                        bidx = ctype.indexOf("boundary=");
                        boundary = ctype.substring(bidx + 9);
                        if (this.m_debug) {
                            System.err.println("// Skipping to boundary");
                        }
                        ssplit.skipToBoundary(boundary);
                    } else {
                        byte[] img;
                        if (this.m_debug) {
                            System.err.println("// Reading to boundary");
                        }
                        if ((img = ssplit.readToBoundary(boundary)).length == 0) {
                            break;
                        }
                        if (this.m_imgidx > 1 && this.m_startTime == 0L) {
                            this.m_startTime = System.currentTimeMillis();
                        }
                        this.updateImage(ctype, img);
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (!this.m_isDefunct);
        }
        catch (Exception e) {
            if (!this.m_collecting) {
                this.m_reporter.reportFailure(e.toString());
            } else if (!this.m_isDefunct) {
                this.m_reporter.reportError(e);
            }
        }
        finally {
            this.unhook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImage(String ctype, byte[] img) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_imageType = ctype;
            this.m_imain = this.m_tk.createImage(img);
            this.m_rawImage = img;
            ++this.m_imgidx;
            this.m_imain.getWidth(new ImageObserver(){

                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    boolean fully;
                    boolean bl = fully = (infoflags & 0x24) != 0;
                    if (fully) {
                        CamStream.this.fireImageChange();
                    }
                    return !fully;
                }
            });
        }
    }

    public void finalize() {
        this.unhook();
    }

    public void unhook() {
        this.m_collecting = false;
        this.m_isDefunct = true;
        try {
            if (this.m_inputStream != null) {
                this.m_inputStream.close();
            }
            this.m_inputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

