/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.server;

import com.charliemouse.cambozola.shared.AppID;
import com.charliemouse.cambozola.shared.CamStream;
import com.charliemouse.cambozola.shared.ExceptionReporter;
import com.charliemouse.cambozola.shared.ImageChangeEvent;
import com.charliemouse.cambozola.shared.ImageChangeListener;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ReplicatingConnection
implements ImageChangeListener {
    private static final String BOUNDARY = "arflebarfle";
    private static Hashtable m_in = new Hashtable();
    private static Hashtable m_out = new Hashtable();
    private static Vector m_clients = new Vector();
    private static CamStream imgStream = null;

    ReplicatingConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnection(URL source, String appname, Socket client) {
        Vector vector = m_clients;
        synchronized (vector) {
            DataOutputStream out;
            DataInputStream in;
            boolean toStart = false;
            if (imgStream == null) {
                ExceptionReporter reporter = new ExceptionReporter(){

                    public void reportError(Throwable t) {
                        this.reportNote("Error:" + t.toString());
                    }

                    public void reportFailure(String s) {
                        this.reportNote("Failure:" + s);
                    }

                    public void reportNote(String s) {
                        System.err.println(s);
                    }
                };
                imgStream = new CamStream(source, appname, null, 1, 1000, reporter, false);
                imgStream.addImageChangeListener(new ReplicatingConnection());
                toStart = true;
            }
            try {
                in = new DataInputStream(client.getInputStream());
                out = new DataOutputStream(new BufferedOutputStream(client.getOutputStream()));
            }
            catch (IOException ie) {
                System.err.println("Unable to start new connection: " + ie);
                try {
                    client.close();
                }
                catch (IOException ie2) {
                    // empty catch block
                }
                return;
            }
            try {
                out.writeBytes("HTTP/1.0 200 OK\r\n");
                out.writeBytes("Server: " + AppID.getAppID().getAppName() + " Replicator\r\n");
                out.writeBytes("Content-Type: multipart/x-mixed-replace;boundary=arflebarfle\r\n");
                out.writeBytes("\r\n");
                out.writeBytes("--arflebarfle\n");
            }
            catch (IOException ie) {
                return;
            }
            System.out.println("New connection from :" + client);
            m_clients.addElement(client);
            m_in.put(client, in);
            m_out.put(client, out);
            if (toStart) {
                imgStream.start();
            }
        }
    }

    private static void disconnect(Socket sock) {
        try {
            DataOutputStream out = (DataOutputStream)m_out.get(sock);
            DataInputStream in = (DataInputStream)m_in.get(sock);
            in.close();
            out.close();
            sock.close();
            m_in.remove(sock);
            m_out.remove(sock);
            m_clients.removeElement(sock);
            if (m_clients.size() == 0) {
                System.err.println("Removing connection");
                imgStream.unhook();
                imgStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void imageChanged(ImageChangeEvent ce) {
        if (imgStream == null) {
            return;
        }
        final byte[] rawimg = imgStream.getRawImage();
        Enumeration e = m_clients.elements();
        while (e.hasMoreElements()) {
            final Socket sock = (Socket)e.nextElement();
            Thread t = new Thread(){

                public void run() {
                    try {
                        DataOutputStream out = (DataOutputStream)m_out.get(sock);
                        out.writeBytes("Content-Type: " + imgStream.getType() + "\n\n");
                        out.write(rawimg, 0, rawimg.length);
                        out.writeBytes("\n--arflebarfle\n");
                    }
                    catch (IOException ie) {
                        ReplicatingConnection.disconnect(sock);
                    }
                }
            };
            t.start();
        }
    }
}

